<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%counter_tariffs}}`.
 */
class m251029_142930_create_counter_tariffs_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%counter_tariffs}}', [
            'id' => $this->primaryKey(),
            'service_type' => $this->string(50)->notNull()->unique(),
            'price' => $this->decimal(10, 2)->notNull(),
            'description' => $this->string(255),
        ]);

        $this->batchInsert('{{%tariff}}', ['service_type', 'price', 'description'], [
            ['electricity', 5.03, 'Электричество'],
            ['gas', 7.39, 'Газ'],
            ['water', 48.24, 'Вода'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%counter_tariffs}}');
    }
}
