<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

$this->title = 'Редактирование тарифа';
$this->params['breadcrumbs'][] = ['label' => 'Админ-панель', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => 'Управление тарифами', 'url' => ['tariffs']];
$this->params['breadcrumbs'][] = $this->title;

$serviceTypes = \app\models\CounterReadings::getServiceTypes();
?>

<div class="admin-container">
    <div class="admin-header">
        <h1 class="admin-title">✏️ Редактирование тарифа</h1>
        <div class="admin-subtitle">Изменение параметров тарифа</div>
    </div>

    <div class="admin-form">
        <?php $form = ActiveForm::begin([
            'id' => 'tariff-update-form',
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control'],
                'errorOptions' => ['class' => 'help-block'],
            ],
        ]); ?>

        <div class="form-group">
            <?= $form->field($model, 'service_type')->dropDownList(
                $serviceTypes,
                [
                    'class' => 'form-control',
                    'disabled' => true // Не разрешаем менять тип услуги
                ]
            ) ?>
            <div class="help-block" style="margin-top: 1vh; font-size: 1.3vh; color: #666;">
                Тип услуги нельзя изменить после создания тарифа
            </div>
        </div>

        <div class="form-group">
            <?= $form->field($model, 'price')->textInput([
                'placeholder' => '0.00',
                'type' => 'number',
                'step' => '0.01',
                'min' => '0'
            ]) ?>
        </div>

        <div class="form-group">
            <?= $form->field($model, 'description')->textarea([
                'placeholder' => 'Описание тарифа...',
                'rows' => 3
            ]) ?>
        </div>

        <div class="form-actions">
            <?= Html::submitButton('💾 Сохранить изменения', ['class' => 'btn btn-primary']) ?>
            <?= Html::a('↶ Отмена', ['tariffs'], ['class' => 'btn btn-outline']) ?>
            <?= Html::a('🗑️ Удалить', ['delete-tariff', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Вы уверены, что хотите удалить этот тариф?',
                    'method' => 'post',
                ],
            ]) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
</div>

<?php
$this->registerCssFile('@web/css/admin.css');
?>