<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Смена пароля';
$this->params['breadcrumbs'][] = ['label' => 'Личный профиль', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="profile-change-password">
    <div class="profile-header">
        <h1 class="profile-title"><?= Html::encode($this->title) ?></h1>
    </div>

    <div class="profile-form">
        <?php $form = ActiveForm::begin([
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control'],
                'errorOptions' => ['class' => 'help-block'],
            ],
        ]); ?>

        <div class="form-grid">
            <?= $form->field($model, 'new_password')->passwordInput() ?>
            <?= $form->field($model, 'confirm_password')->passwordInput() ?>
        </div>

        <div class="form-actions">
            <?= Html::submitButton('Изменить пароль', ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-outline']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
</div>