<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

$this->title = 'Личный профиль';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="profile-index">
    <div class="profile-header">
        <h1 class="profile-title"><?= Html::encode($this->title) ?></h1>
        <div class="profile-actions">
            <?= Html::a('Редактировать данные', ['update'], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Сменить пароль', ['change-password'], ['class' => 'btn btn-outline']) ?>
        </div>
    </div>

    <div class="profile-card">
        <div class="profile-info">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    [
                        'attribute' => 'full_name',
                        'label' => 'ФИО',
                        'contentOptions' => ['class' => 'profile-value'],
                        'labelOptions' => ['class' => 'profile-label']
                    ],
                    [
                        'attribute' => 'phone',
                        'label' => 'Телефон',
                        'contentOptions' => ['class' => 'profile-value'],
                        'labelOptions' => ['class' => 'profile-label']
                    ],
                    [
                        'attribute' => 'email',
                        'label' => 'Email',
                        'contentOptions' => ['class' => 'profile-value'],
                        'labelOptions' => ['class' => 'profile-label']
                    ],
                    [
                        'attribute' => 'address',
                        'label' => 'Адрес',
                        'contentOptions' => ['class' => 'profile-value'],
                        'labelOptions' => ['class' => 'profile-label']
                    ],
                    [
                        'attribute' => 'residents_count',
                        'label' => 'Количество проживающих',
                        'contentOptions' => ['class' => 'profile-value'],
                        'labelOptions' => ['class' => 'profile-label']
                    ],
                ],
            ]) ?>
        </div>
    </div>
</div>