<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Редактирование профиля';
$this->params['breadcrumbs'][] = ['label' => 'Личный профиль', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="profile-update">
    <div class="profile-header">
        <h1 class="profile-title"><?= Html::encode($this->title) ?></h1>
    </div>

    <div class="profile-form">
        <?php $form = ActiveForm::begin([
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control'],
                'errorOptions' => ['class' => 'help-block'],
            ],
        ]); ?>

        <div class="form-grid">
            <?= $form->field($model, 'full_name')->textInput(['maxlength' => true]) ?>
            <?= $form->field($model, 'phone')->textInput(['maxlength' => true]) ?>
            <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
            <?= $form->field($model, 'address')->textarea(['rows' => 3]) ?>
            <?= $form->field($model, 'residents_count')->textInput(['type' => 'number', 'min' => 1]) ?>
        </div>

        <div class="form-actions">
            <?= Html::submitButton('Сохранить изменения', ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-outline']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
</div>