<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

$this->title = 'История показаний';
$this->params['breadcrumbs'][] = $this->title;

$serviceIcons = [
    'electricity' => '⚡',
    'gas' => '🔥', 
    'water' => '💧'
];
?>

<div class="readings-index">
    <div class="readings-header">
        <div class="header-content">
            <h1 class="readings-title"><?= Html::encode($this->title) ?></h1>
            <div class="readings-subtitle">История всех переданных показаний счетчиков</div>
        </div>
        <div class="readings-actions">
            <?= Html::a('➕ Передать показания', ['create'], ['class' => 'btn btn-primary btn-large']) ?>
        </div>
    </div>

    <?php Pjax::begin(['timeout' => 5000]); ?>
    
    <div class="readings-table-container">
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'tableOptions' => ['class' => 'table readings-table'],
            'layout' => "{items}\n<div class='table-footer'>{summary}\n{pager}</div>",
            'summary' => 'Показано <b>{begin}-{end}</b> из <b>{totalCount}</b> записей',
            'summaryOptions' => ['class' => 'summary'],
            'pager' => [
                'options' => ['class' => 'pagination'],
                'linkOptions' => ['class' => 'page-link'],
                'activePageCssClass' => 'active',
                'disabledPageCssClass' => 'disabled',
            ],
            'columns' => [
                [
                    'attribute' => 'date',
                    'label' => '📅 Дата',
                    'format' => 'date',
                    'headerOptions' => ['class' => 'table-header date-header'],
                    'contentOptions' => ['class' => 'table-cell date-cell'],
                    'headerOptions' => ['class' => 'table-header'],
                ],
                [
                    'attribute' => 'service_type',
                    'label' => 'Услуга',
                    'value' => function($model) use ($serviceIcons) {
                        return $serviceIcons[$model->service_type] . ' ' . $model->getServiceTypeLabel();
                    },
                    'format' => 'raw',
                    'headerOptions' => ['class' => 'table-header service-header'],
                    'contentOptions' => ['class' => 'table-cell service-cell'],
                ],
                [
                    'attribute' => 'previous_readings',
                    'label' => '📊 Предыдущие',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->previous_readings, 2);
                    },
                    'headerOptions' => ['class' => 'table-header readings-header'],
                    'contentOptions' => ['class' => 'table-cell readings-cell'],
                ],
                [
                    'attribute' => 'current_readings',
                    'label' => '📈 Текущие',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->current_readings, 2);
                    },
                    'headerOptions' => ['class' => 'table-header readings-header'],
                    'contentOptions' => ['class' => 'table-cell readings-cell current-reading'],
                ],
                [
                    'attribute' => 'consumption',
                    'label' => '📉 Расход',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->consumption, 2);
                    },
                    'headerOptions' => ['class' => 'table-header consumption-header'],
                    'contentOptions' => ['class' => 'table-cell consumption-cell'],
                ],
                [
                    'attribute' => 'tariff',
                    'label' => '💰 Тариф',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->tariff, 2) . ' руб';
                    },
                    'headerOptions' => ['class' => 'table-header tariff-header'],
                    'contentOptions' => ['class' => 'table-cell tariff-cell'],
                ],
                [
                    'attribute' => 'sum',
                    'label' => '💳 Сумма',
                    'value' => function($model) {
                        return Yii::$app->formatter->asDecimal($model->sum, 2) . ' руб';
                    },
                    'headerOptions' => ['class' => 'table-header sum-header'],
                    'contentOptions' => ['class' => 'table-cell sum-cell'],
                ],
                [
                    'attribute' => 'status',
                    'label' => '📋 Статус',
                    'value' => function($model) {
                        $statusClass = 'status-' . $model->status;
                        $statusIcons = [
                            'new' => '⏳',
                            'accepted' => '✅',
                            'rejected' => '❌'
                        ];
                        
                        return Html::tag('span', 
                            $statusIcons[$model->status] . ' ' . $model->getStatusLabel(), 
                            ['class' => "status $statusClass"]
                        );
                    },
                    'format' => 'raw',
                    'headerOptions' => ['class' => 'table-header status-header'],
                    'contentOptions' => ['class' => 'table-cell status-cell'],
                ],
            ],
            'rowOptions' => function($model) {
                return [
                    'class' => 'table-row status-' . $model->status,
                    'data-id' => $model->id
                ];
            },
        ]); ?>
    </div>
    
    <?php Pjax::end(); ?>

    <div class="readings-summary">
        <div class="summary-grid">
            <div class="summary-card">
                <div class="card-header">
                    <div class="card-icon">📝</div>
                    <h3>Как передавать показания</h3>
                </div>
                <div class="card-content">
                    <ol class="instructions-list">
                        <li>Снимите показания со всех счетчиков</li>
                        <li>Введите текущие показания в соответствующие поля</li>
                        <li>Убедитесь, что показания больше предыдущих</li>
                        <li>Нажмите "Передать все показания"</li>
                        <li>Дождитесь проверки администратором</li>
                    </ol>
                </div>
            </div>

            <div class="summary-card">
                <div class="card-header">
                    <div class="card-icon">ℹ️</div>
                    <h3>Статусы заявок</h3>
                </div>
                <div class="card-content">
                    <div class="status-info">
                        <div class="status-item">
                            <span class="status-indicator status-new">⏳</span>
                            <span class="status-text">Новая - на проверке</span>
                        </div>
                        <div class="status-item">
                            <span class="status-indicator status-accepted">✅</span>
                            <span class="status-text">Принята - показания верны</span>
                        </div>
                        <div class="status-item">
                            <span class="status-indicator status-rejected">❌</span>
                            <span class="status-text">Отклонена - ошибка в показаниях</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>